/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.impl.DiveAnimator;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Dive
extends Action {
    private boolean justJumped = false;
    private double playerYSpeedOld = 0.0;
    private double playerYSpeed = 0.0;

    public double getPlayerYSpeed(float partialTick) {
        return Mth.m_14139_((double)partialTick, (double)this.playerYSpeedOld, (double)this.playerYSpeed);
    }

    @Override
    public void onWorkingTickInLocalClient(Player player, Parkourability parkourability, IStamina stamina) {
        this.playerYSpeedOld = this.playerYSpeed;
        this.playerYSpeed = player.m_20184_().m_7098_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        boolean can = this.justJumped && !stamina.isExhausted() && !parkourability.get(Crawl.class).isDoing() && !player.m_20143_() && parkourability.get(FastRun.class).canActWithRunning(player) && parkourability.getActionInfo().can(Dive.class) && WorldUtil.existsDivableSpace((LivingEntity)player);
        startInfo.putDouble(player.m_20184_().f_82480_);
        this.justJumped = false;
        return can;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        return !player.m_21255_() && !player.m_150110_().f_35935_ && !player.m_20072_() && !player.m_20077_() && !player.m_6069_() && !player.m_20096_() && !stamina.isExhausted();
    }

    public void onJump(Player player, Parkourability parkourability, IStamina stamina) {
        if (!player.m_7578_()) {
            return;
        }
        this.justJumped = true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        double ySpeed;
        this.playerYSpeedOld = this.playerYSpeed = (ySpeed = startData.getDouble());
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new DiveAnimator(ySpeed));
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.None;
    }

    @Override
    public void saveSynchronizedState(ByteBuffer buffer) {
        buffer.putDouble(this.playerYSpeed).putDouble(this.playerYSpeedOld);
    }

    @Override
    public void restoreSynchronizedState(ByteBuffer buffer) {
        this.playerYSpeed = buffer.getDouble();
        this.playerYSpeedOld = buffer.getDouble();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        double ySpeed;
        this.playerYSpeedOld = this.playerYSpeed = (ySpeed = startData.getDouble());
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new DiveAnimator(ySpeed));
        }
    }
}

